/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpMsg.c,v 1.2 1999/12/14 01:05:09 cpeterson Exp $
____________________________________________________________________________*/
/*
 * pgpMsg.c -- a way to obtain the list of PGP Messages
 *
 * Written by:	Derek Atkins <warlord@MIT.EDU>
 */
#include <stdio.h>	/* For sprintf() */

#include "pgpConfig.h"

#define PGPMSG(msg, string) { msg, string },

/* List of all message codes */
struct pgpmsg_t {
	int msg;
	char const *string;
};

static struct pgpmsg_t const pgpmsglist[] = {
#include "pgpMsg.h"
	{ 0, 0 }	/* End-of-list placeholder */
};

/* Get rid of warning from gcc about missing prototype */
char const  *pgpmsgString (int code);

char const *
pgpmsgString (int code)
{
	unsigned i;
	static char buf[] = "Unknown msg code xxxxxxxxx";
	/*                   1234567890123456789 */

	for (i = 0; i < sizeof (pgpmsglist)/sizeof (*pgpmsglist); i++) {
		if (pgpmsglist[i].msg == code)
			return pgpmsglist[i].string;
	}
	sprintf (buf+19, "%+d", code);
	return buf;
}
